# 第四章 中国开源社区发展现状

当前我们所身处的数字化时代几乎都是由开源代码所构建的，伴随着开源运动在中国的落地与发展，中国的开源社区从最初的单一且独立社区不断地演进，呈现出今天以项目社区、用户社区、综合社区为核心的百花齐放的繁荣景象。本篇将为带来国内开源环境下不同的开源社区发展形态与现状。

## 4.1 中国开源社区的起源与发展历程

#### 从时间的维度

全球开源运动发起距今已有二十多年，管中窥豹，我们可以观察到国内开源技术的发展其实存在着一些明显的趋势。

十几年前，很多人认为“开源 = Linux”，因为当时的Linux 操作系统、桌面办公软件（GNOME、OpenOffice）和浏览器（Mozilla）作为开源项目的主战场，掀起了第一波开源的浪潮；

近十年，随着互联网的兴起，开源的项目和技术呈现百花齐放之盛况，从数据库到中间件、从前端到后端、从编程语言到编译器、从物联网到微服务、从大数据到人工智能，开源的技术和项目越来越丰富和多样化；

最近五年，随着移动互联网和云计算在中国的蓬勃发展，我们看到了中国开源崛起的力量。根据时间的迭代，中国开源也从早期的跟随者、参与者，逐渐变成影响者、引领者和创作者。

中国开始涌现出大量开源项目的开发者，中国企业的开源项目开始捐献给基金会孵化，中国开始定义自己的开源许可证协议（木兰宽松协议）并被OSI接受，中国开始成立中国的开源基金会（开放原子基金会），这些都是中国开源开始成熟的很重要的标志。 

#### 集中与分布式

在早期的时候，开源主要集中在几个主要社区，这些社区成熟的标准之一就是“是否有开源基金会”。当然全球的开源基金会也是掰着手指头可以数出来的，如经典老牌的 Linux、Apache、Mozilla 基金会等，聚集了一大群优秀的开源人才和企业的参与，并且在长达20多年的开源历程中经久不衰。这是经典的开源1.0模式。

当开源技术开始多元化，尤其当代码的分享和开发变得便捷，基于Git的代码托管平台的流行，开源进入了一种新的分布式状态。更细分领域技术和项目的出现，促成了更低的沟通成本和更多开源人才的聚集。

如同互联网早期是通过主要的门户网站来服务于全球网民，发展至今每个人都很容易创建并运营自己的自媒体账号。

2019 年GitHub发布的行业报告中，用户群和活跃贡献度排名第二的是中国，我们看到了中国开源环境的成熟以及呈分布式状态发展的势头。这也意味着进入到了开源2.0模式。 

#### 小众与出圈

十几年前，Linux的爱好者会通过北京 Linux 用户组聚集在一起，他们经常会去北京一家位于东直门的餐厅的地下一层，“地下”这个词有着双重含义。那个时候的开源圈子，还鲜为人知，活跃于一小群早期的开源人之间。到了2022年的今天，开源呈现出一种出圈的状态。

在横向上，更多的领域开始谈论开源，开始了解开源。近年以来，政府部门开始关注开源，学校开始推广开源的课程和认证，企业们开始考虑成立开源委员会，VC创投开始垂青开源项目，开源已经成了多轮融资以及上市评估一个非常重要的维度和评价方向。

纵向的从开源项目之间去看，我们观察到的更多是「融合」，领域之间的界限开始模糊，开源项目之间的界限开始模糊。
从个人到生态

中国开源社区早期的时候更多是以用户的方式去参与，这也是为什么我们会听到北京某某用户组，上海某某用户组。

到了 2022 年，我们比较少听到新成立某某用户组这个词了，更多地听到了联盟、基金会、行业联盟、组织。这意味着开源不再是以个人用户的方式在参与，而是以开发者、项目、企业、联盟、基金会的方式来呈现，这也同样印证了中国开源的成熟，规模化，进阶和蓬勃发展的势头。

## 4.2 中国开源社区的现状特征

近年来，在国家政策以及开源社区蓄力之下，除了国家级的开放原子开源基金会，行业性质（例如CCF的开源发展委员会、福州开源研究院）、头部企业主导（百度旗下的飞浆和超级链、阿里旗下的龙蜥社区、腾讯云旗下的腾源会等）、区域性开源组织不断涌现，高校的学生开源俱乐部数量也在不断增加。增长最快是IT基础设施相关的开源项目社区。

据中国开源软件联盟不完全统计，截止2022年3月，国内各类开源社区已经超过500个，按照综合社区平台、项目型社区和用户组社区三类进行汇总，项目型社区增速最为显著。

项目型社区是指聚焦在聚焦在特定开源项目，包括代码贡献和协作、集成测试、应用实践、用户反馈等核心功能，大部分项目型社区由背后的机构或企业来资助或直接运营，代表型项目社区有：OpenHarmony、TiDB社区、RT-Thread、百度飞桨社区、龙蜥开源社区（OpenAnolis）等。

* 用户组社区主要是开源爱好者自发形成的小型社区，以知识分享、经验交流和传播开源文化为主要目标。其中最为典型的有LiuxnFans、西电开源社区、物联网自动化社区iot.cechina、Go开发者社区、Python中国社区等。
* 综合社区平台是指具备开源代码、项目孵化、开源治理、媒体等多种服务功能的社区，内容和用户中开源领域居多，其他垂直小众社区也在该社区平台构建自己的影响力。代表性如CSDN社区（Gitcode开源代码平台），开源中国社区（Gitee）、思否、51CTO、博客园等。
 
还有一些小类如活动型：以开源社、腾源会为代表；学术型：以木兰社区、白玉兰社区为代；协会性质：CCF开源发展委员会、福州开源研究院；行业性质：Open Islands（基于隐私计算）等。

从社区类型看，以项目为导向的开源社区数量最多，这是符合开源生态以项目为基础的发展模式。从区域上看，开源社区还是主要集中在北上广深杭等一线城市。

中国开源社区也迎来重要的发展阶段，正在从以学习应用国外开源项目和技术为主的爱好型社区为主，逐渐涌现一大批以应用、学习、贡献和开源创作的专业综合社区。

社区走向专业在外部表现为和中国开源项目的蓬勃发展同频，在过去的2021年，由开源项目驱动的开源平台和开源社区发展也非常迅猛。
 
### 4.2.1 中国开源代码托管平台

随着开源项目的不断增加，以及国内开发者在使用到GitHub、GitLab 等平台时，经常遇到访问速度太慢，甚至有时还会遇到无法连接的情况。在此趋势下，中国也诞生了一批优秀的代码托管平台。

#### GitCode

2020年9月，中国专业IT开发者社区CSDN推出全新升级的开源项目创新服务平台GitCode，其秉承“创新、开放、协作、共享”的开源价值观，致力于为大规模开源开放协同创新助力赋能，打造创新成果孵化和新时代开发者培养的开源创新生态。作为独立的第三方开源社区，GitCode 不仅具备 GitLab 的先进技术，同时也充分考虑了中国用户的使用习惯，多方合力创建开放、协作、共享的全球开源技术共同体。截至2022年5月，GitCode开发者数量已超120w+，项目入驻 20w+，开源组织5w+，百度、阿里、腾讯、华为、旷视等知名企业，以及OceanBase、OpenCV、Jenkins等优秀项目均已入驻GitCode。

#### Gitee

码云（Gitee）是 OSCHINA 推出的代码托管协作开发平台，支持Git和SVN，提供免费的私有仓库托管。2016年推出企业版，提供企业级代码托管服务，成为开发领域领先的SaaS服务提供商。

#### GitLink

GitLink（确实开源）是CCF官方指定的开源创新服务平台，截至目前，已有5万开发者、1000+组织入驻，仓库数量累计140万。它为我国创新型软件产业发展提供了关键技术支撑和实践指南，支持了我国航空、航天、国防等多个关键领域的可信软件生产，为包括新一代人工智能启智社区、ARM绿色计算社区、科技部云计算与大数据木兰社区、科技委可控开源创造行动红山社区等的建设提供关键技术支撑，为我国关键领域开源社区生态建设发挥了重要作用。
Coding

Coding是深圳市腾云扣钉科技有限公司推出的产品，其重点面向团队和企业的代码协作开发服务。Coding的项目管理包含任务、讨论、文件等功能，支持多成员协作，并且深度集成了代码仓库的操作与状态。

### 4.2.2 中国开源项目社区蓬勃发展

从开发者规模和开发者合作、参与层次性，部分开源社区已经发展到非常庞大的规模，在社区生态上发出显著的成绩。

部分开源项目社区清单：

|社区名 |领域  |项目地址   |项目社区介绍|
|--------|------------|---------|---------|
|通信行业开源社区|通信|暂无|通信行业开源社区具备通信行业属性的国内开源组织，由国内通信行业相关机构自发形成，旨在推动国内通信行业开源技术安全可靠使用，促进我国开源生态健康可持续性发展。自成立以来，定期开展开源软件技术研究和使用经验研讨活动，成员单位积极整合优势资源和技术成果共享开源经验，共同推动通信行业开源生态健康发展。|
|科技制造开源社区|路径遍历|暂无|通信行业开源社区具备通信行业属性的国内开源组织，由国内通信行业相关机构自发形成，旨在推动国内通信行业开源技术安全可靠使用，促进我国开源生态健康可持续性发展。自成立以来，定期开展开源软件技术研究和使用经验研讨活动，成员单位积极整合优势资源和技术成果共享开源经验，共同推动通信行业开源生态健康发展。|
|科技制造开源社区|暂无|暂无|科技制造开源社区为具备科技制造属性的国内开源组织，由国内科技制造行业相关机构自发形成，推动国内科技制造行业开源供应链合规治理，打造开源生态良好建设环境，下设全权成员参与社区决策，另外设置普通成员和技术委员会，科技制造开源社区提供开源技术应用交流平台，共同探讨科技制造行业开源痛点问题，打造国内科技制造行业良好开源生态，帮助科技制造行业降低开源风险。|
|金融行业开源技术应用社区|金融|暂无|金融行业开源技术应用社区是国内首个金融行业开源社区，主要服务于金融机构。自成立以来，定期开展开源软件技术研究和使用经验研讨活动，成员单位积极整合优势资源和技术成果共享开源经验，共同推动金融行业开源生态健康发展|
|汽车行业开源社区|暂无|暂无|汽车行业开源社区为具备汽车制造属性的国内开源组织，由国内汽车行业相关机构自发形成，应对汽车行业供应链条长，开源治理场景复杂等问题，下设全权成员参与社区决策，另外设置普通成员和技术委员会，汽车行业开源社区提供开源技术应用交流平台，共同探讨科技制造行业开源痛点问题，打造国内汽车行业良好开源生态，帮助汽车行业降低开源风险。|
|开放群岛（Open Islands）开源社区|隐私计算|公众号“Open Islands”|开放群岛（Open Islands）开源社区是由深圳数据交易有限公司联合国家智库、国家单位、高校、大型金融机构、大型互联网公司等近50家发起单位牵头成立的国内首个国际化自主可控隐私计算开源社区。|
|星策开源社区|暂无|http://startogether.ai/|星策开源社区是一个聚焦于企业智能化转型，由企事业单位、高等院校、科研单位、非营利性组织等按照自愿、平等、开源、协作的基础上组成的非盈利性中立的开源社区。社区的使命是连接企业和AI，以开源的方式共享共建企业智能转型的方法论、案例、实践和技术，助力企业智能化转型成功。|
|龙晰社区|操作系统|https://openanolis.org|一个操作系统开源社区及创新平台，由国内、外领先操作系统、芯片、云计算公司共同发起，致力于通过开放的社区合作，构建国内自主Linux 开源发行版及开源创新技术，推动软、硬件及应用生态繁荣发展。|
|openEuler社区|操作系统|https://www.openeuler.org/zh/|openEuler 是由 OpenAtom Foundation 开发和运营的开源平台。 其愿景是通过社区合作，打造创新平台，构建支持多处理器架构、统一和开放的操作系统openEuler，推动软硬件生态繁荣发展。|
|OpenHarmony社区|操作系统|https://www.openharmony.cn/|OpenHarmony是由开放原子开源基金会（OpenAtom Foundation）孵化及运营的开源项目,目标是面向全场景、全连接、全智能时代、基于开源的方式，搭建一个智能终端设备操作系统的框架和平台，促进万物互联产业的繁荣发展。|
|RT-thread社区 |操作系统| https://www.rt-thread.org/  |RT-Thread是一款由上海睿赛德电子科技主导开发的开源实时操作系统，它也是集实时操作系统（RTOS）内核、中间件组件和开发者社区于一体的技术平台。|
|OceanBase社区|  数据库|  https://open.oceanbase.com/  |OceanBase 社区版是一款开源分布式 HTAP（Hybrid Transactional/Analytical Processing）数据库管理系统，具有原生分布式架构，支持金融级高可用、透明水平扩展、分布式事务、多租户和语法兼容等企业级特性。OceanBase 内核通过大规模商用场景的考验，已服务众多行业客户，现面向未来持续构建内核技术竞争力。|
|TiDB社区 |数据库 |	https://tidb.net/	|TiDB 是 PingCAP 公司自主设计、研发的开源分布式关系型数据库，是一款同时支持在线事务处理与在线分析处理 (Hybrid |Transactional and Analytical Processing, HTAP) 的融合型分布式数据库产品，具备水平扩容或者缩容、金融级高可用、实时 HTAP、云原生的分布式数据库、兼容 MySQL 5.7 协议和 MySQL 生态等重要特性。|
|MongoDB中文社区|	数据库|	https://mongoing.com/	|MongoDB中文社区是围绕MongoDB生态建立的中文技术社区，获得MongoDB官方的认可和支持。社区关注MongoDB以及相关数据产品和工具。来自MongoDB官方的工程师，阿里腾讯等大型互联网公司及业界MongoDB专家、MongoDB书籍作者等组成社区核心成员。|
|TDengine社区	|数据库|	https://www.taosdata.com/	|TDengine是涛思数据开发的一款高性能、分布式、支持SQL的时序数据库，其核心代码包括集群功能全部开源，同时TDengine还带有内建的缓存、流式计算、数据订阅等系统功能，能大幅减少研发和运维的复杂度，可广泛应用于物联网、车联网、工业互联网、IT 运维、金融等领域。|
|ClickHouse中文社区	|大数据|	http://www.clickhouse.com.cn/	|ClickHouse.com.cn社区为国内最专业最具影响力的ClickHouse开源技术社区，致力于ClickHouse 的技术研究、推广和普及。|
|飞桨PaddlePaddle社区	|人工智能|	https://www.paddlepaddle.org.cn/	|飞桨(PaddlePaddle)是百度开发的一款集深度学习核心框架、工具组件和服务平台为一体的技术先进、功能完备的开源深度学习平台，已被中国企业广泛使用，深度契合企业应用需求，拥有活跃的开发者社区生态。|
|华为MindSpore社区	|人工智能| 	https://www.mindspore.cn/community	|MindSpore是华为开源的自研AI框架。其希望通过社区合作，面向全场景构建最佳昇腾匹配、支持多处理器架构的开放AI框架，为算法工程师和数据科学家提供开发友好、运行高效、部署灵活的体验，帮助人工智能软硬件应用生态繁荣发展。|
|Apollo社区	|汽车|	https://developer.apollo.auto/	|Apollo开发者社区是百度致力于为全球自动驾驶开发者和合作伙伴提供的一个学习、交流的平台,助力开发者快速了解并使用自动驾驶技术。|




### 4.3 中国开源社区发展的挑战和趋势

国内的开源社区的运营和治理能力目前大部分还处于比较初级的阶段。形式上具备国外开源社区的治理架构，但还没有真正发挥出开源开放和协作的效应，社区贡献还是主要来源于项目的发起方。

社区是生态影响力的具体呈现。中国开源社区的发展阶段和中国技术、开发者水平在全球软件技术中的地位相符，虽然规模庞大，但特别在基础领域原创性还远远不足。

展现在中国开源社区中，主动贡献的开发者比例较少，社区主要面向服务项目的推广布道、和开发者应用学习价值。

据联盟和各社区的抽样访谈和统计，中国开源社区在发展上有如下三个不足和障碍：

* 中国开发者对开源生态的认识普遍不足，愿意积极参与开源社区贡献的开发者比例和规模远远不足。
* 中国开源社区缺乏专业的治理机制，社区成熟度普遍不足。
* 缺乏充足和专业的社区治理人才。尤其缺乏擅长治理架构的专家和总监级人才。

主要遇到的主观挑战：

* 社区的主导权主要是集中在项目发起方，很少做到真正的社区自治，社区贡献主要还是来自项目发起方；
* 很少社区真正做到上游优先的倡导；
* 大部分开源社区照搬Apache的社区治理模式，没有考虑到国内开源文化、开发者的现状和国外有很大的区别，导致开源社区的影响力都集中在少数人中；
* IT基础类的开源项目现在主要集中在国内，但是偏向框架、应用类型的开源项目还是主要捐赠到国外的开源基金会。
 
主要遇到的外部挑战：

* 国内的开源文化还比较薄弱，大众对于开源的贡献和回报机制还不是特别了解，更多还是停留在软件和代码可以免费下载的观念中；
* 开源社区对于软件合规的重视程度还不够。
 
随着国家不断加强对科技自主可控的宏观政策执行、数字化转型迫在眉睫以及开源写入到十四五规划中，各行各业都日益开始重视开源，特别是一批基础性的IT项目陆续开源，形成了一股强大的驱动力，驱动国内的开源社区的蓬勃发展。中国的开源社区未来可期，大有所为。具体建议：

* 需要加大开源的布道；
* 需要加强软件合规的普及；
* 加强对开源社区治理的研究。
 
